
Type TArbiter


'#Region Public members
	Field geometryA:TGeom
	Field geometryB:TGeom
'#End Region 
	
'#Region Private Members
	Field _physicsSimulator:TPhysicsSimulator
	Field _frictionCoefficientCombined:Float
	
	Field _contactlist:TContactList
	Field _newContactList:TContactList
	Field _mergedContactList:TContactList
	
	'used as temp vars for ref/out methods
	Field _vec1:Vector2 = Vector2.Zero() 
	Field _vec2:Vector2 = Vector2.Zero() 
	Field _vec3:Vector2 = Vector2.Zero() 
	Field _vec4:Vector2 = Vector2.Zero() 
	Field _vec5:Vector2 = Vector2.Zero() 
	Field _float1:Float = 0
	Field _float2:Float = 0
	
	'NEED A COMPARER CLASS/functionPointer?
'#End Region 
		
'#Region Public Properties
	Method GetGeomA:TGeom() 
		Return geometryA
	End Method
	
	Method SetGeomA(value:TGeom) 
		geometryA = value
	End Method
	
	Method GetGeomB:TGeom() 
		Return geometryB
	End Method
	
	Method SetGeomB(value:TGeom) 
		geometryB = value
	End Method
'#End Region 
	
'#Region Cosntruction/Initialization
	Method New() 
		
	End Method
	
	Function CreateArbiter:TArbiter(geometry1:TGeom, geometry2:TGeom, physicsSimulator:TPhysicsSimulator) 
		Local a:TArbiter = New TArbiter
		a.ConstructArbiter(geometry1, geometry2, physicsSimulator) 
		Return a
	End Function
	
	Method ConstructArbiter(geometry1:TGeom, geometry2:TGeom, physicsSimulator:TPhysicsSimulator) 
		_physicsSimulator = physicsSimulator
		
		If TGeom.LessThan(geometry1, geometry2) Then
			geometryA = geometry1
			geometryB = geometry2
		Else
			geometryA = geometry2
			geometryB = geometry1
		End If
		
		Select physicsSimulator._frictionType
			Case FrictionType.Average
				Self._frictionCoefficientCombined = (geometryA._frictionCoefficient + geometryB._frictionCoefficient) / 2.0
			Case FrictionType.Minimum
				Self._frictionCoefficientCombined = Min(geometryA._frictionCoefficient, geometryB._frictionCoefficient) 
			Default
				Self._frictionCoefficientCombined = (geometryA._frictionCoefficient + geometryB._frictionCoefficient) / 2.0
		End Select
		
		_InitializeContactLists(physicsSimulator._maxContactsToDetect) 
	End Method
	
	Method _InitializeContactLists(maxContactsToDetect:Int) 
		If _contactList = Null Then _contactList = New TContactList
		If _newContactList = Null Then _newContactList = New TContactList
		If _mergedContactLIst = Null Then _mergedContactList = New TContactList 
	End Method
'#End Region 
	
'#Region Public Methods
	Method GetContactCount:Int() 
		Return _contactList.Count() 
	End Method
	
	' fully exposed for convienence. should be treated as readonly. do not add or remove directly from this list
	Method GetContactList:TContactList() 
		Return _contactList
	End Method
	
	
	Method Reset() 
		geometryA = Null
		geometryB = Null
		_contactList.Clear() 
		_newContactList.Clear() 
		_mergedContactList.Clear() 
	End Method


	'#Region PreStepImpulse
	'#Region PreStepImpulse variables
	Field _r1:Vector2 = Vector2.Zero() 
	Field _r2:Vector2 = Vector2.Zero() 
	Field _rn1:Float
	Field _rn2:Float
	Field _rt1:Float
	Field _rt2:Float
	Field _kTangent:Float
	Field _minf:Float
	Field _restitution:Float
	Field _kNormal:Float
	'#End Region 
	Method PreStepImpulse(inverseDt:Float) 
		If Not(geometryA._collisionResponseEnabled) Or Not(geometryB._collisionResponseEnabled) Then Return
		For Local contact:TContact = EachIn _contactList
			
			' calculate the contact offst from body position
			Vector2.SubtractVectorsRef(contact.Position, geometryA._body._position, _r1) 
			Vector2.SubtractVectorsRef(contact.Position, geometryB._body._position, _r2) 
			
			'project the normal onto offset vectors
			_rn1 = Vector2.Dot(_r1, contact.Normal) 
			_rn2 = Vector2.Dot(_r2, contact.Normal) 
			
			'calculate mass normal
			Local invMassSum:Float = geometryA._body._inverseMass + geometryB._body._inverseMass
			_float1 = Vector2.Dot(_r1, _r1) 
			_float2 = Vector2.Dot(_r2, _r2) 
			_kNormal = invMassSum + geometryA._body._inverseMomentOfInertia * (_float1 - _rn1 * _rn1) + geometryB._body._inverseMomentOfInertia * (_float2 - _rn2 * _rn2) 
			contact.SetMassNormal(1.0 / _kNormal) 
			
			'calculate mass tangent
			_float1 = 1
			Calculator.CrossVFRef(contact.Normal, _float1, _tangent)
			_rt1 = Vector2.Dot(_r1, _tangent) 
			_rt2 = Vector2.Dot(_r2, _tangent) 
			_kTangent = geometryA._body._inverseMass + geometryB._body._inverseMass
			
			_float1 = Vector2.Dot(_r1, _r1)
			_float2 = Vector2.Dot(_r2, _r2)
			_kTangent:+geometryA._body._inverseMomentOfInertia * (_float1 - _rt1 * _rt1) + geometryB._body._inverseMomentOfInertia * (_float2 - _rt2 * _rt2) 
			contact.SetMassTangent(1.0 / _kTangent) 
			
			'calc velocity bias
			_minf = Min(0, _physicsSimulator._allowedPenetration + contact.Seperation) 
			contact._normalVelocityBias = -_physicsSimulator._biasFactor * inverseDt * _minf
			
			'compute the restitution, we average the restitution of the two bodies
			'restitution = (2.0f + _geometryA.RestitutionCoefficient + _geometryB.RestitutionCoefficient) * 0.5f
			_restitution = (geometryA._restitutionCoefficient + geometryB._restitutionCoefficient) *.5
			
			'calc bounce velocity
			geometryA._body.GetVelocityAtWorldOffset(_r1, _vec1) 
			geometryB._body.GetVelocityAtWorldOffset(_r2, _vec2) 
			Vector2.SubtractVectorsRef(_vec2, _vec1, _dv) 

			'calc velocity difference along contact normal
			_vn = Vector2.Dot(_dv, contact.Normal) 
			contact._bounceVelocity = _vn * _restitution
			
			'apply accumulated impulse
			'INLINED
			'Vector2.ScaleRef(contact.Normal, contact._normalImpulse, _vec1)
			_vec1.X = contact.Normal.X * contact._normalImpulse
			_vec1.Y = contact.Normal.Y * contact._normalImpulse			
			'Vector2.ScaleRef(_tangent, contact._tangentImpulse, _vec2)
			_vec2.X = _tangent.X * contact._tangentImpulse
			_vec2.Y = _tangent.Y * contact._tangentImpulse
			'Vector2.AddVectorsRef(_vec1, _vec2, _impulse)
			_impulse.X = _vec1.X + _vec2.X
			_impulse.Y = _vec1.Y + _vec2.Y
			
			geometryB._body.ApplyImpulseAtWorldOffset(_impulse, _r2) 
			
			'Vector2.ScaleRef(_impulse, - 1, _impulse)
			_impulse.X = _impulse.X * -1
			_impulse.Y = _impulse.Y * -1
			
			geometryA._body.ApplyImpulseAtWorldOffset(_impulse, _r1) 
			contact._normalImpulseBias = 0

		Next

	End Method
	'#End Region 
	
	'#Region ApplyImpulse
	'#Region variables for applyImpulse
	Field _tangent:Vector2 = Vector2.Zero() 
	Field _dv:Vector2 = Vector2.Zero() 
	
	Field _vn:Float = 0
	Field _normalVelocityBias:Float = 0
	Field _normalImpulseBias:Float = 0
	Field _normalImpulseBiasOriginal:Float = 0
	
	Field _normalImpulse:Float = 0
	Field _oldNormalImpulse:Float = 0
	Field _maxTangentImpulse:Float = 0
	
	Field _vt:Float = 0
	Field _tangentImpulse:Float = 0
	Field _oldTangentImpulse:Float = 0
	
	Field _impulse:Vector2 = Vector2.Zero() 
	Field _impulseBias:Vector2 = Vector2.Zero() 
	'#End Region 
	Method ApplyImpulse() 
		If Not(geometryA._collisionResponseEnabled) Or Not(geometryB._collisionResponseEnabled) Then Return
		For Local contact:TContact = EachIn _contactList
			
			'#region INLINE:Vector2.Subtract(ref contact.Position, ref geometryA.body.position, out contact.R1) 
			contact._r1.X = contact.Position.X - geometryA._body._position.X
			contact._r1.Y = contact.Position.Y - geometryA._body._position.Y
			'#endregion
			
			'#region INLINE:Vector2.Subtract(ref contact.Position, ref geometryB.body.position, out contact.R2) 
			contact._r2.X = contact.Position.X - geometryB._body._position.X
			contact._r2.Y = contact.Position.Y - geometryB._body._position.Y
			'#endregion			

			' calc velocity difference
			geometryA._body.GetVelocityAtWorldOffset(contact._r1, _vec1) 
			geometryB._body.GetVelocityAtWorldOffset(contact._r2, _vec2) 
			
			'#region INLINE:Vector2.Subtract(ref vec2, ref vec1, out dv) 
			_dv.X = _vec2.X - _vec1.X
			_dv.Y = _vec2.Y - _vec1.Y
			'#endregion			

			' calc velocity difference along contact normal
			'#region INLINE:Vector2.Dot(ref dv, ref contact.Normal, out vn) 
			_vn = (_dv.X * contact.Normal.X) + (_dv.Y * contact.Normal.Y) 
			'#endregion

			'float normalImpulse = contact.MassNormal * (-vn + contact.NormalVelocityBias) 'comment for preserve momentum
			_normalImpulse = contact._massNormal * -(_vn + contact._bounceVelocity)   		'uncomment for preserve momentum

			'clamp accumulated impulse
			_oldNormalImpulse = contact._normalImpulse
			contact._normalImpulse = Max(_oldNormalImpulse + _normalImpulse, 0) 
			_normalImpulse = contact._normalImpulse - _oldNormalImpulse
			

			'apply contact impulse
			'#region INLINE:Vector2.Multiply(ref contact.Normal, normalImpulse, out impulse) 
			_impulse.X = contact.Normal.X * _normalImpulse
			_impulse.Y = contact.Normal.Y * _normalImpulse
			'#endregion
	
			geometryB._body.ApplyImpulseAtWorldOffset(_impulse, contact._r2) 
	
			'#region INLINE:Vector2.Multiply(ref impulse, - 1, out impulse) 
			_impulse.X = _impulse.X * -1
			_impulse.Y = _impulse.Y * -1
			'#endregion
			
			geometryA._body.ApplyImpulseAtWorldOffset(_impulse, contact._r1) 
			
			'calc velocity bias difference (bias preserves momentum)
			geometryA._body.GetVelocityBiasAtWorldOffset(contact._r1, _vec1) 
			geometryB._body.GetVelocityBiasAtWorldOffset(contact._r2, _vec2) 

			'#region INLINE:Vector2.Subtract(ref vec2, ref vec1, out dv) 
			_dv.X = _vec2.X - _vec1.X
			_dv.Y = _vec2.Y - _vec1.Y
			'#endregion			
		
			'calc velocity bias along contact normal
			'#region INLINE:Vector2.Dot(ref dv, ref contact.Normal, out normalVelocityBias) 
			_normalVelocityBias = (_dv.X * contact.Normal.X) + (_dv.Y * contact.Normal.Y) 
			'#endregion
			

			_normalImpulseBias = contact._massNormal * (- _normalVelocityBias + contact._normalVelocityBias) 
			_normalImpulseBiasOriginal = contact._normalImpulseBias
			contact._normalImpulseBias = Max(_normalImpulseBiasOriginal + _normalImpulseBias, 0) 
			_normalImpulseBias = contact._normalImpulseBias - _normalImpulseBiasOriginal
			
			'#region INLINE:Vector2.Multiply(ref contact.Normal, normalImpulseBias, out impulseBias) 
			_impulseBias.X = contact.Normal.X * _normalImpulseBias
			_impulseBias.Y = contact.Normal.Y * _normalImpulseBias
			
			'#endregion
			
			'apply bias impulse
			geometryB._body.ApplyBiasImpulseAtWorldOffset(_impulseBias, contact._r2) 
			
			'#region INLINE:Vector2.Multiply(ref impulseBias, - 1, out impulseBias) 
			_impulseBias.X = _impulseBias.X * -1
			_impulseBias.Y = _impulseBias.Y * -1
			'#endregion
			
			geometryA._body.ApplyBiasImpulseAtWorldOffset(_impulseBias, contact._r1) 
			
			'calc relative velocity at contact
			geometryA._body.GetVelocityAtWorldOffset(contact._r1, _vec1) 
			geometryB._body.GetVelocityAtWorldOffset(contact._r2, _vec2) 

			'#region INLINE:Vector2.Subtract(ref vec2, ref vec1, out dv) 
			_dv.X = _vec2.X - _vec1.X
			_dv.Y = _vec2.Y - _vec1.Y
			'#endregion
	
			_maxTangentImpulse = Self._frictionCoefficientCombined * contact._normalImpulse
			
			_float1 = 1
			
			'#region INLINE:Calculator.Cross(ref contact.Normal, ref float1, out tangent) 
			_tangent.X = _float1 * contact.Normal.Y
			_tangent.Y = -_float1 * contact.Normal.X
			'#endregion
			
			'float vt = Vector2.Dot(dv, tangent)
			'#region INLINE:Vector2.Dot(ref dv, ref tangent, out vt) 
			_vt = (_dv.X * _tangent.X) + (_dv.Y * _tangent.Y) 
			'#endregion
			
			_tangentImpulse = contact._massTangent * (- _vt) 
			
			'clamp friction
			_oldTangentImpulse = contact._tangentImpulse
			contact._tangentImpulse = MathHelper.Clamp(_oldTangentImpulse + _tangentImpulse, - _maxTangentImpulse, _maxTangentImpulse) 
			_tangentImpulse = contact._tangentImpulse - _oldtangentImpulse
			
			' apply friction impulse
			'#region INLINE:Vector2.Multiply(ref tangent, tangentImpulse, out impulse) 
			_impulse.X = _tangent.X * _tangentImpulse
			_impulse.Y = _tangent.Y * _tangentImpulse
			'#endregion
			
			' apply impulse
			geometryB._body.ApplyImpulseAtWorldOffset(_impulse, contact._r2) 
			'#region INLINE:Vector2.Multiply(ref impulse, - 1, out impulse) 
			_impulse.X = _impulse.X * -1
			_impulse.Y = _impulse.Y * -1
			'#endregion		
			geometryA._body.ApplyImpulseAtWorldOffset(_impulse, contact._r1) 
			
		Next

	End Method
	'#End Region 
			
	Method Collide() 
		_newContactList.Clear() 
		_Collide(Self.geometryA, Self.geometryB, _newContactList) 
		_mergedContactList.Clear() 
		
		For Local contact:TContact = EachIn _newContactList
			Local index:Int = _contactList.IndexOfSafe(contact) 
			If index > - 1 Then
				'continuation of collision
				'TODO: check to see if this is actuall redundant. 
				' looks like this is done in C# due to how structs work.
				contact._normalImpulse = TContact(_contactList.AtIndex(index))._normalImpulse
				contact._tangentImpulse = TContact(_contactList.AtIndex(index))._tangentImpulse
				_mergedContactList.add(contact)
			Else
				'first time collision
				_mergedContactList.add(contact)
			End If
		Next
		
		' clear contact pool.
		For Local contact:TContact = EachIn _contactList
			_physicsSimulator._contactPool.Free(contact) 
		Next
		_contactList.Clear() 		
		For Local contact:TContact = EachIn _mergedContactList
			_contactList.add(contact) 
		Next
	End Method
	
	'#Region collide variables
	Field _feature:TFeature = New TFeature
	Field _localVertex:Vector2 = Vector2.Zero() 
	Field _vertRef:Vector2 = Vector2.Zero() 
	Field _matrixInverseTemp:TMatrix = TMatrix.Identity() 
	Field _matrixTemp:TMatrix = TMatrix.Identity()
	Field _contactIdTemp:TContactId = TContactId.Create(2, 0, 1)' the 2 and 1 are hardcoded as they do not change upon creation. 0 is the only dynamic factor.
	'#End Region 
	Method _Collide(geometry1:TGeom, geometry2:TGeom, contactList:TContactList) 

		Local vertexIndex:Int = -1 
		For Local i:Int = 0 To geometry2._worldVertices._vecArray.Length - 1
			If contactList.Count() = _physicsSimulator._maxContactsToDetect Then
				Exit
			End If
			If geometry1._grid = Null Then ' grid can be null for 'one-way' collision (points)
				Exit
			End If
			vertexIndex:+1

			_vertRef.X = geometry2._worldVertices._vecArray[i].X
			_vertRef.Y = geometry2._worldVertices._vecArray[i].Y
			
			geometry1.TransformToLocalCoordinates(_vertRef, _localVertex) 
			If Not(geometry1.Intersect(_localVertex, _feature)) Then
				Continue
			End If
			
			If _feature.Distance < 0 Then
				geometry1.TransformNormalToWorld(_feature.Normal, _feature.Normal) 
				Local contact:TContact = TContact(_physicsSimulator._contactPool.Fetch())
			'	_contactIdTemp._geometryAIndex = 2
				_contactIdTemp._geometryAVertex = vertexIndex
			'	_contactIdtemp._geometryBIndex = 1
				contact.Init(geometry2._worldVertices._vecArray[i], _feature.Normal, _feature.Distance, _contactIdTemp)
				contactList.add(contact) 
			End If
		Next

		
		For Local i:Int = 0 To geometry1._worldVertices._vecArray.Length - 1
			If contactList.Count() = _physicsSimulator._maxContactsToDetect Then
				Exit
			End If
			If geometry2._grid = Null Then ' grid can be null for 'one-way' collision (points)
				Exit
			End If
			vertexIndex:+1

			_vertRef.X = geometry1._worldVertices._vecArray[i].X
			_vertRef.Y = geometry1._worldVertices._vecArray[i].Y
			
			geometry2.TransformToLocalCoordinates(_vertRef, _localVertex) 
			If Not(geometry2.Intersect(_localVertex, _feature)) Then
				Continue
			End If
			
			If _feature.Distance < 0 Then
				geometry2.TransformNormalToWorld(_feature.Normal, _feature.Normal) 
				_feature.Normal.X = _feature.Normal.X * -1
				_feature.Normal.Y = _feature.Normal.Y * -1
				Local contact:TContact = TContact(_physicsSimulator._contactPool.Fetch())
			'	_contactIdTemp._geometryAIndex = 2
				_contactIdTemp._geometryAVertex = vertexIndex
			'	_contactIdtemp._geometryBIndex = 1
				contact.Init(geometry1._worldVertices._vecArray[i], _feature.Normal, _feature.Distance, _contactIdTemp)
				contactList.add(contact) 
			End If
		Next
		
		' sort contact list by separation (amount of penetration)
		contactlist.Sort()

		'resolve deepest contacts first
		Local contactCount:Int = contactList.Count() 
		If contactCount > _physicsSimulator._maxContactsToResolve Then
			contactlist.RemoveRange(Self._physicsSimulator._maxContactsToResolve, contactCount - _physicsSimulator._maxContactsToResolve, _physicsSimulator._contactPool) 
		End If

		' allow user to cancel collision if desired
		If Not contactList.IsEmpty() Then
			If Not geometry1.OnCollision(geometry1, geometry2, contactlist) Then
				contactList.Clear()
			End If
		End If
		' allow user to cancel collision if desired
		If Not contactlist.IsEmpty() Then
			If Not geometry2.OnCollision(geometry2, geometry1, contactlist) Then
				contactlist.Clear()
			End If
		End If
		
		'#Region TODO: add collision event handling here.
		rem
		 //allow user to cancel collision if desired
            if (geometry1.Collision != null) {
                if (contactList.Count > 0) {
                    if (!geometry1.Collision(geometry1, geometry2, contactList)) {
                        contactList.Clear();
                    }
                }
            }

            //allow user to cancel collision if desired
            if (geometry2.Collision != null) {
                if (contactList.Count > 0) {
                    if (!geometry2.Collision(geometry2, geometry1, contactList)) {
                        contactList.Clear();
                    }
                }
            }
		end rem
		'#End Region 
		
	End Method
	
	Method Compare:Int(o:Object) 
		If TArbiter(o) Then
			Local other:TArbiter = TArbiter(o) 			
			If geometryA.Equals(other.geometryA) And geometryB.Equals(other.geometryB) Then
				Return 0
			Else
				Return - 1
			End If
		End If
		Throw "The object being compared must be of type 'TArbiter'"
		Return - 1
	End Method
'#End Region 
End Type
